package com.ejie.p06b.util;

import com.ejie.p06b.log.P06BLog;
import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.w3c.dom.Document;

public class Y31JanoServiceAbstractFactory {
	private static final double JDK_MAYOR_VERSION = Double.parseDouble(System
			.getProperty("java.version").substring(0, 3));
	private static final String METHOD = "getInstance";

	public static Y31JanoService getInstance()
			throws Y31JanoServiceGenericException {
		Class c = null;
		try {
			if (JDK_MAYOR_VERSION >= 1.6D) {
				P06BLog.send(2, "", "JDK_MAYOR_VERSION >= 1.6D");
				ClassLoader cl = Thread.currentThread().getContextClassLoader();
				if (cl == null) {
					cl = Y31JanoServiceAbstractFactory.class.getClassLoader();
				}

				c = cl.loadClass("w11.com.ejie.y31.service.factory.Y31JanoServiceFactory");
			} else {
				P06BLog.send(2, "", "!(JDK_MAYOR_VERSION >= 1.6D)");
				ClassLoader cl = Thread.currentThread().getContextClassLoader();
				if (cl == null) {
					cl = Y31JanoServiceAbstractFactory.class.getClassLoader();
				}
				c = cl.loadClass("w08.com.ejie.y31.service.factory.Y31JanoServiceFactory");
			}

		} catch (ClassNotFoundException e) {
			P06BLog.send(2, "", "Adri1:" + e.getMessage());
			for (StackTraceElement elemento : e.getStackTrace()) {
				P06BLog.send(2, "", elemento.toString());
			}
			throw new Y31JanoServiceGenericException(e);
		}

		Method method = null;
		Y31JanoService r = null;
		try {
			method = c.getMethod("getInstance", null);
		} catch (SecurityException e) {
			P06BLog.send(2, "", "Adri2:" + e.getMessage());
			for (StackTraceElement elemento : e.getStackTrace()) {
				P06BLog.send(2, "", elemento.toString());
			}
			throw new Y31JanoServiceGenericException(e);
		} catch (NoSuchMethodException e) {
			P06BLog.send(2, "", "Adri3" + e.getMessage());
			for (StackTraceElement elemento : e.getStackTrace()) {
				P06BLog.send(2, "", elemento.toString());
			}
			throw new Y31JanoServiceGenericException(e);
		}
		try {
			r = (Y31JanoService) method.invoke(null, null);
		} catch (IllegalArgumentException e) {
			P06BLog.send(2, "", "Adri4" + e.getMessage());
			for (StackTraceElement elemento : e.getStackTrace()) {
				P06BLog.send(2, "", elemento.toString());
			}
			throw new Y31JanoServiceGenericException(e);
		} catch (IllegalAccessException e) {
			P06BLog.send(2, "", "Adri5" + e.getMessage());
			for (StackTraceElement elemento : e.getStackTrace()) {
				P06BLog.send(2, "", elemento.toString());
			}
			throw new Y31JanoServiceGenericException(e);
		} catch (InvocationTargetException e) {
			P06BLog.send(2, "", "Adri6" + e.getMessage());
			for (StackTraceElement elemento : e.getStackTrace()) {
				P06BLog.send(2, "", elemento.toString());
			}
			throw new Y31JanoServiceGenericException(e);
		}

		return r;
	}

	public static void main(String[] args) throws IllegalArgumentException,
			ClassNotFoundException, IllegalAccessException,
			InvocationTargetException, Y31JanoServiceGenericException,
			SecurityException, NoSuchMethodException,
			Y31JanoServiceFileNameFormatException,
			Y31JanoServiceMongoDbGenericException,
			Y31JanoServiceAccesDeniedException,
			Y31JanoServiceEventJmsException,
			Y31JanoServiceFileNotFoundException {
		Y31JanoService s = getInstance();
		Document d = null;

		Y31AttachmentBean ab = s.move(d, "/web/upload/log4j.dtd",
				"/r02/casa/log4j.dtd");
	}
}
